﻿/****** Object:  StoredProcedure [dbo].[sp_ImportRespondent]    Script Date: 12/15/2014 8:54:39 AM ******/
DROP PROCEDURE [dbo].[sp_ImportRespondent]
GO

/****** Object:  StoredProcedure [dbo].[sp_ImportRespondent]    Script Date: 12/15/2014 8:54:39 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/****** Object:  StoredProcedure [dbo].[sp_ImportRespondent]    Script Date: 11/09/2011 10:13:23 ******/
  -- Changed way to extract code for the time zone (bug #11450)
  CREATE PROCEDURE [dbo].[sp_ImportRespondent]
  (
    @projectId int,
    @userId int,
    @resRespondent varchar(10),
    @resLanguage int,
    @resTimeZone int,
    @resIntervCall varchar(10),
    @resConfidPhone bit,
    @resPhone varchar(20),
    @resPriority int,
    @resWaveImportNo int,
    @resActive int,
    @ExtractTimeZoneFromAreaCode bit,
    @CheckPhoneForDuplicate bit,
    @resSeed         int,
    @DialingMode int = 0,
    @IntLevel int = 0,
 @ResCodeResult varchar(2) = null,
 @ResLastCompQuest int = 0,
 @CyclePhoneNumber int = 1,
 @ManualDialing int = 0
  )
  AS
    if @CheckPhoneForDuplicate =1  and @resphone <> '' and @resphone is not null
    begin
      declare @key varchar(10)
      select @key = resRespondent from dbo.respondent where resphone=@resphone
      if @key is not null
      begin
        RAISERROR ('VOXCOERROR_1000 Duplicate phone numbers are not allowed.', 16, 1)
        return
      end
    end
     if @ExtractTimeZoneFromAreaCode =1
    begin
      declare @parTimeZone int,
           @resPhoneSearch varchar(20)
   set @resPhoneSearch=replace(@resphone,'-','')
      select @parTimeZone = coalesce(timezone,0) 
      from   areacodetz
   where areacodetz.code = Substring(@resPhoneSearch,Patindex('%[0-9]%',@resPhoneSearch),3)
   and areacodetz.exchange = Substring(@resPhoneSearch,(Patindex('%[0-9]%',@resPhoneSearch) + 3),3)
    if @parTimeZone is null
    begin
     select @resTimeZone = coalesce(timezone,0) 
     from   areacodetz
     where  areacodetz.code = Substring(@resPhoneSearch,Patindex('%[0-9]%',@resPhoneSearch),3)
     and areacodetz.exchange = '***'
    end 
    set @resTimeZone=isnull(@parTimeZone,@resTimeZone)
    end
    insert into dbo.respondent (ResRespondent,ResLanguage,ResTimeZone,ResCallbackDate,ResIntervCall,ResTimeSlot,ResCallCount,ResLastCallDate,ResVersion,ResPriority,ResCompleted,ResConfidPhone,ResSeed,Resphone,ResCodeResult,ResWaveNo,ResBlocked,ResCompPredictive,ResCall,ResMonitored,ResLastCompQuest,ResPreviousCallDate,ResWaveImportNo, ResActive, projectid,modifiedby,modified,collectmode,DialingMode,IntLevel,CyclePhoneNumber,ManualDialing)
    values(
      @resRespondent,
      @resLanguage,
      @resTimeZone,
      0,
      @resIntervCall,
      0,
      0,
      null,
      null,
      @resPriority,
      0,
      @resConfidPhone,
      @resSeed,
      @resPhone,
      @resCodeResult,
      0,
      1,
      0,
      0,
      0,
      @ResLastCompQuest,
      null,
      @resWaveImportNo,
      @resActive,
      @projectId,
      @userId,
      GETUTCDATE(),
      0,
      @DialingMode,
      @IntLevel,
	  @CyclePhoneNumber,
	  @ManualDialing
    )
    if @ExtractTimeZoneFromAreaCode =1
    begin
      declare @tzone varchar(2)
      if @resTimeZone <10  
        set @tzone = '0' + cast(@restimezone as varchar)
      else 
        set @tzone= cast(@restimezone as varchar)
      exec Sp_updaterespondentresponse @projectId,@userId,0,@resRespondent,'TZONE',1,1,@tzone,'',0,0,'Importation'
    end

GO


